/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.player;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import rpgboss.lib.Layout;
import rpgboss.lib.ThreadChecked;
import rpgboss.lib.ThreadChecked$class;
import rpgboss.model.PictureSlots$;
import rpgboss.model.Project;
import rpgboss.model.resource.Msgfont;
import rpgboss.model.resource.Msgfont$;
import rpgboss.model.resource.MsgfontMetadata;
import rpgboss.model.resource.Picture;
import rpgboss.model.resource.Picture$;
import rpgboss.model.resource.PictureMetadata;
import rpgboss.model.resource.RpgAssetManager;
import rpgboss.model.resource.Windowskin;
import rpgboss.model.resource.Windowskin$;
import rpgboss.model.resource.WindowskinMetadata;
import rpgboss.player.AnimationManager;
import rpgboss.player.FloatTweener;
import rpgboss.player.MovedPicture;
import rpgboss.player.PictureLike;
import rpgboss.player.PictureSequence;
import rpgboss.player.Rectangle;
import rpgboss.player.ScreenText;
import rpgboss.player.TexturePicture;
import rpgboss.player.Tweener;
import rpgboss.player.Tweener$class;
import rpgboss.player.WindowManager$;
import rpgboss.player.entity.AnimationPlayer;
import rpgboss.player.entity.Window;
import rpgboss.player.entity.Window$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rEc\u0001B\u0001\u0003\u0001\u001d\u0011QbV5oI><X*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0001H.Y=fe*\tQ!A\u0004sa\u001e\u0014wn]:\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0004Y&\u0014\u0017BA\n\u0011\u00055!\u0006N]3bI\u000eCWmY6fIB\u0011QCH\u0007\u0002-)\u0011q\u0003G\u0001\u0006g24GG\u001b\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0017\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\na!Y:tKR\u001cX#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001\u0003:fg>,(oY3\u000b\u0005!\"\u0011!B7pI\u0016d\u0017B\u0001\u0016&\u0005=\u0011\u0006oZ!tg\u0016$X*\u00198bO\u0016\u0014\b\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000f\u0005\u001c8/\u001a;tA!Aa\u0006\u0001BC\u0002\u0013\u0005q&A\u0004qe>TWm\u0019;\u0016\u0003A\u0002\"!\r\u001a\u000e\u0003\u001dJ!aM\u0014\u0003\u000fA\u0013xN[3di\"AQ\u0007\u0001B\u0001B\u0003%\u0001'\u0001\u0005qe>TWm\u0019;!\u0011!9\u0004A!b\u0001\n\u0003A\u0014aB:de\u0016,gnV\u000b\u0002sA\u0011\u0011BO\u0005\u0003w)\u00111!\u00138u\u0011!i\u0004A!A!\u0002\u0013I\u0014\u0001C:de\u0016,gn\u0016\u0011\t\u0011}\u0002!Q1A\u0005\u0002a\nqa]2sK\u0016t\u0007\n\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003:\u0003!\u00198M]3f]\"\u0003\u0003\u0002C\"\u0001\u0005\u000b\u0007I\u0011\u0001#\u0002-I,g\u000eZ3sS:<wJ\u001a4G_J$Vm\u001d;j]\u001e,\u0012!\u0012\t\u0003\u0013\u0019K!a\u0012\u0006\u0003\u000f\t{w\u000e\\3b]\"A\u0011\n\u0001B\u0001B\u0003%Q)A\fsK:$WM]5oO>3gMR8s)\u0016\u001cH/\u001b8hA!)1\n\u0001C\u0001\u0019\u00061A(\u001b8jiz\"b!T(Q#J\u001b\u0006C\u0001(\u0001\u001b\u0005\u0011\u0001\"B\u0011K\u0001\u0004\u0019\u0003\"\u0002\u0018K\u0001\u0004\u0001\u0004\"B\u001cK\u0001\u0004I\u0004\"B K\u0001\u0004I\u0004\"B\"K\u0001\u0004)\u0005bB+\u0001\u0005\u0004%\tAV\u0001\u0011C:LW.\u0019;j_:l\u0015M\\1hKJ,\u0012a\u0016\t\u0003\u001dbK!!\u0017\u0002\u0003!\u0005s\u0017.\\1uS>tW*\u00198bO\u0016\u0014\bBB.\u0001A\u0003%q+A\tb]&l\u0017\r^5p]6\u000bg.Y4fe\u0002Bq!\u0018\u0001A\u0002\u0013\u0005a,A\bue\u0006t7/\u001b;j_:\fE\u000e\u001d5b+\u0005y\u0006CA\u0005a\u0013\t\t'BA\u0003GY>\fG\u000fC\u0004d\u0001\u0001\u0007I\u0011\u00013\u0002'Q\u0014\u0018M\\:ji&|g.\u00117qQ\u0006|F%Z9\u0015\u0005\u0015D\u0007CA\u0005g\u0013\t9'B\u0001\u0003V]&$\bbB5c\u0003\u0003\u0005\raX\u0001\u0004q\u0012\n\u0004BB6\u0001A\u0003&q,\u0001\tue\u0006t7/\u001b;j_:\fE\u000e\u001d5bA!9Q\u000e\u0001b\u0001\n\u0003q\u0017!\u0005;sC:\u001c\u0018\u000e^5p]R;X-\u001a8feV\tq\u000e\u0005\u0002Oa&\u0011\u0011O\u0001\u0002\r\r2|\u0017\r\u001e+xK\u0016tWM\u001d\u0005\u0007g\u0002\u0001\u000b\u0011B8\u0002%Q\u0014\u0018M\\:ji&|g\u000eV<fK:,'\u000f\t\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0003%!\u0018N\u001c;D_2|'/F\u0001x!\tAx0D\u0001z\u0015\tQ80\u0001\u0005he\u0006\u0004\b.[2t\u0015\taX0A\u0002hIbT!A \u000f\u0002\u0011\t\fG\r\\8hS\u000eL1!!\u0001z\u0005\u0015\u0019u\u000e\\8s\u0011\u001d\t)\u0001\u0001Q\u0001\n]\f!\u0002^5oi\u000e{Gn\u001c:!\u0011%\tI\u0001\u0001b\u0001\n\u0003\tY!A\u0006uS:$Hk^3f]\u0016\u0014XCAA\u0007%\u0015\ty\u0001CA\f\r\u001d\t\t\"a\u0005\u0001\u0003\u001b\u0011A\u0002\u0010:fM&tW-\\3oizB\u0001\"!\u0006\u0001A\u0003%\u0011QB\u0001\ri&tG\u000fV<fK:,'\u000f\t\t\u0005\u001d\u0006eq/C\u0002\u0002\u001c\t\u0011q\u0001V<fK:,'\u000fC\u0005\u0002 \u0001\u0001\r\u0011\"\u0001\u0002\"\u0005Qq/\u001b8e_^\u001c8.\u001b8\u0016\u0005\u0005\r\u0002c\u0001\u0013\u0002&%\u0019\u0011qE\u0013\u0003\u0015]Kg\u000eZ8xg.Lg\u000eC\u0005\u0002,\u0001\u0001\r\u0011\"\u0001\u0002.\u0005qq/\u001b8e_^\u001c8.\u001b8`I\u0015\fHcA3\u00020!I\u0011.!\u000b\u0002\u0002\u0003\u0007\u00111\u0005\u0005\t\u0003g\u0001\u0001\u0015)\u0003\u0002$\u0005Yq/\u001b8e_^\u001c8.\u001b8!\u0011%\t9\u0004\u0001a\u0001\n\u0003\tI$A\txS:$wn^:lS:$V\r\u001f;ve\u0016,\"!a\u000f\u0011\u0007a\fi$C\u0002\u0002@e\u0014q\u0001V3yiV\u0014X\rC\u0005\u0002D\u0001\u0001\r\u0011\"\u0001\u0002F\u0005)r/\u001b8e_^\u001c8.\u001b8UKb$XO]3`I\u0015\fHcA3\u0002H!I\u0011.!\u0011\u0002\u0002\u0003\u0007\u00111\b\u0005\t\u0003\u0017\u0002\u0001\u0015)\u0003\u0002<\u0005\u0011r/\u001b8e_^\u001c8.\u001b8UKb$XO]3!\u0011%\ty\u0005\u0001b\u0001\n\u0003\t\t&\u0001\u0003g_:$XCAA*!\r!\u0013QK\u0005\u0004\u0003/*#aB'tO\u001a|g\u000e\u001e\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002T\u0005)am\u001c8uA!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014a\u00024p]R\u0014W\u000e]\u000b\u0003\u0003G\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003SJ\u0018aA43I&!\u0011QNA4\u0005)\u0011\u0015\u000e^7ba\u001a{g\u000e\u001e\u0005\n\u0003c\u0002\u0001\u0019!C\u0001\u0003C\n\u0001b\u00184p]R\u0014W\u000e\u001d\u0005\n\u0003k\u0002\u0001\u0019!C\u0001\u0003o\nAb\u00184p]R\u0014W\u000e]0%KF$2!ZA=\u0011%I\u00171OA\u0001\u0002\u0004\t\u0019\u0007\u0003\u0005\u0002~\u0001\u0001\u000b\u0015BA2\u0003%yfm\u001c8uE6\u0004\b\u0005C\u0004\u0002\u0002\u0002!\t!a!\u0002!U\u0004H-\u0019;f\u0005&$X.\u00199G_:$HcA3\u0002\u0006\"A\u0011qQA@\u0001\u0004\tI)A\u0007eSN$\u0018N\\2u\u0007\"\f'o\u001d\t\u0005\u0003\u0017\u000b\tJD\u0002\n\u0003\u001bK1!a$\u000b\u0003\u0019\u0001&/\u001a3fM&!\u00111SAK\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0012\u0006\t\u0013\u0005e\u0005A1A\u0005\u0002\u0005m\u0015\u0001\u00039jGR,(/Z:\u0016\u0005\u0005u\u0005#B\u0005\u0002 \u0006\r\u0016bAAQ\u0015\t)\u0011I\u001d:bsB)\u0011\"!*\u0002*&\u0019\u0011q\u0015\u0006\u0003\r=\u0003H/[8o!\rq\u00151V\u0005\u0004\u0003[\u0013!a\u0003)jGR,(/\u001a'jW\u0016D\u0001\"!-\u0001A\u0003%\u0011QT\u0001\na&\u001cG/\u001e:fg\u0002B\u0011\"!.\u0001\u0005\u0004%I!a.\u0002\u000f]Lg\u000eZ8xgV\u0011\u0011\u0011\u0018\t\u0007\u0003w\u000b)-!3\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\fq!\\;uC\ndWMC\u0002\u0002D*\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9-!0\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*\u0019\u0011q\u001a\u0002\u0002\r\u0015tG/\u001b;z\u0013\u0011\t\u0019.!4\u0003\r]Kg\u000eZ8x\u0011!\t9\u000e\u0001Q\u0001\n\u0005e\u0016\u0001C<j]\u0012|wo\u001d\u0011\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\u0006i1/\u001a;Ue\u0006t7/\u001b;j_:$R!ZAp\u0003GDq!!9\u0002Z\u0002\u0007q,\u0001\u0005f]\u0012\fE\u000e\u001d5b\u0011\u001d\t)/!7A\u0002}\u000b\u0001\u0002Z;sCRLwN\u001c\u0005\b\u0003S\u0004A\u0011AAv\u0003I\u0011XO\\!gi\u0016\u0014HK]1og&$\u0018n\u001c8\u0015\u0007\u0015\fi\u000f\u0003\u0005\u0002p\u0006\u001d\b\u0019AAy\u0003\u001d\u0019Gn\\:ve\u0016\u0004B!CAzK&\u0019\u0011Q\u001f\u0006\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004bBA}\u0001\u0011\u0005\u00111`\u0001\u0011M&t\u0017n\u001d5Ue\u0006t7/\u001b;j_:$\u0012!\u001a\u0005\u0007\u0003\u007f\u0004A\u0011\u0001#\u0002\u0019%tGK]1og&$\u0018n\u001c8\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006\u0005i1/\u001a;XS:$wn^:lS:$2!\u001aB\u0004\u0011!\u0011IA!\u0001A\u0002\u0005%\u0015AD<j]\u0012|wo]6j]B\u000bG\u000f\u001b\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0003%\tG\rZ,j]\u0012|w\u000fF\u0002f\u0005#A\u0001Ba\u0005\u0003\f\u0001\u0007\u0011\u0011Z\u0001\u0007o&tGm\\<\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a\u0005a!/Z7pm\u0016<\u0016N\u001c3poR!\u0011\u0011\u0018B\u000e\u0011!\u0011\u0019B!\u0006A\u0002\u0005%\u0007b\u0002B\u0010\u0001\u0011\u0005!\u0011E\u0001\fM>\u001cWo],j]\u0012|w\u000fF\u0002f\u0005GA\u0001Ba\u0005\u0003\u001e\u0001\u0007\u0011\u0011\u001a\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0003E\u0019\bn\\<QS\u000e$XO]3Cs:\u000bW.\u001a\u000b\nK\n-\"q\u0006B\u001a\u0005{AqA!\f\u0003&\u0001\u0007\u0011(\u0001\u0003tY>$\b\u0002\u0003B\u0019\u0005K\u0001\r!!#\u0002\t9\fW.\u001a\u0005\t\u0005k\u0011)\u00031\u0001\u00038\u00051A.Y=pkR\u00042a\u0004B\u001d\u0013\r\u0011Y\u0004\u0005\u0002\u0007\u0019\u0006Lx.\u001e;\t\u0013\t}\"Q\u0005I\u0001\u0002\u0004y\u0016!B1ma\"\f\u0007b\u0002B\"\u0001\u0011\u0005!QI\u0001\u0010g\"|w\u000fU5diV\u0014X\rT8paRYQMa\u0012\u0003J\t5#q\nB)\u0011\u001d\u0011iC!\u0011A\u0002eB\u0001Ba\u0013\u0003B\u0001\u0007\u0011\u0011R\u0001\u000bM>dG-\u001a:QCRD\u0007\u0002\u0003B\u001b\u0005\u0003\u0002\rAa\u000e\t\u0013\t}\"\u0011\tI\u0001\u0002\u0004y\u0006\"\u0003B*\u0005\u0003\u0002\n\u00111\u0001:\u0003=1'/Y7fgB+'oU3d_:$\u0007b\u0002B,\u0001\u0011\u0005!\u0011L\u0001\fg\"|w\u000fU5diV\u0014X\rF\u0003f\u00057\u0012i\u0006C\u0004\u0003.\tU\u0003\u0019A\u001d\t\u0011\t}#Q\u000ba\u0001\u0003S\u000b!B\\3x!&\u001cG/\u001e:f\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005K\n1\"\\8wKBK7\r^;sKRIQMa\u001a\u0003j\t-$q\u000e\u0005\b\u0005[\u0011\t\u00071\u0001:\u0011\u001d\t)O!\u0019A\u0002}C\u0001B!\u001c\u0003b\u0001\u0007!qG\u0001\n]\u0016<H*Y=pkRDqA!\u001d\u0003b\u0001\u0007q,\u0001\u0005oK^\fE\u000e\u001d5b\u0011\u001d\u0011)\b\u0001C\u0001\u0005o\n1\u0002[5eKBK7\r^;sKR\u0019QM!\u001f\t\u000f\t5\"1\u000fa\u0001s!9!Q\u0010\u0001\u0005\u0002\u0005m\u0018!\u0002:fg\u0016$\bb\u0002BA\u0001\u0011\u0005!1Q\u0001\u0007kB$\u0017\r^3\u0015\t\t\u0015%\u0011\u0013\t\u0007\u0003w\u00139Ia#\n\t\t%\u0015Q\u0018\u0002\b\u0011\u0006\u001c\bnU3u!\u0011\tYM!$\n\t\t=\u0015Q\u001a\u0002\u0010\u0003:LW.\u0019;j_:\u0004F.Y=fe\"9!1\u0013B@\u0001\u0004y\u0016!\u00023fYR\f\u0007b\u0002BL\u0001\u0011\u0005!\u0011T\u0001\raJ,W*\u00199SK:$WM\u001d\u000b\u0006K\nm%Q\u0015\u0005\t\u0005;\u0013)\n1\u0001\u0003 \u0006)!-\u0019;dQB!\u0011Q\rBQ\u0013\u0011\u0011\u0019+a\u001a\u0003\u0017M\u0003(/\u001b;f\u0005\u0006$8\r\u001b\u0005\t\u0005O\u0013)\n1\u0001\u0003*\u0006a1o\u0019:fK:\u001c\u0015-\\3sCB\u0019\u0001Pa+\n\u0007\t5\u0016P\u0001\nPeRDwn\u001a:ba\"L7mQ1nKJ\f\u0007\"\u0003BY\u0001\u0001\u0007I\u0011\u0001BZ\u0003=\u00198M]3f]R+\u0007\u0010^!se\u0006LXC\u0001B[!\u0019\tYLa.\u0003<&!!\u0011XA_\u0005-iU\u000f^1cY\u0016d\u0015n\u001d;\u0011\u00079\u0013i,C\u0002\u0003@\n\u0011!bU2sK\u0016tG+\u001a=u\u0011%\u0011\u0019\r\u0001a\u0001\n\u0003\u0011)-A\ntGJ,WM\u001c+fqR\f%O]1z?\u0012*\u0017\u000fF\u0002f\u0005\u000fD\u0011\"\u001bBa\u0003\u0003\u0005\rA!.\t\u0011\t-\u0007\u0001)Q\u0005\u0005k\u000b\u0001c]2sK\u0016tG+\u001a=u\u0003J\u0014\u0018-\u001f\u0011\t\u000f\t=\u0007\u0001\"\u0001\u0003R\u0006Y\u0011\r\u001a3Ee\u0006<H+\u001a=u)\r)%1\u001b\u0005\t\u0005+\u0014i\r1\u0001\u0003<\u0006!A/\u001a=u\u0011\u001d\u0011I\u000e\u0001C\u0001\u00057\faB]3n_Z,GI]1x)\u0016DH\u000fF\u0002F\u0005;DqAa8\u0003X\u0002\u0007\u0011(\u0001\u0002jI\"I!1\u001d\u0001A\u0002\u0013\u0005!Q]\u0001\u000fe\u0016\u001cG/\u00198hY\u0016\f%O]1z+\t\u00119\u000f\u0005\u0004\u0002<\n]&\u0011\u001e\t\u0004\u001d\n-\u0018b\u0001Bw\u0005\tI!+Z2uC:<G.\u001a\u0005\n\u0005c\u0004\u0001\u0019!C\u0001\u0005g\f!C]3di\u0006tw\r\\3BeJ\f\u0017p\u0018\u0013fcR\u0019QM!>\t\u0013%\u0014y/!AA\u0002\t\u001d\b\u0002\u0003B}\u0001\u0001\u0006KAa:\u0002\u001fI,7\r^1oO2,\u0017I\u001d:bs\u0002BqA!@\u0001\t\u0003\u0011y0\u0001\tbI\u0012$%/Y<SK\u000e$\u0018M\\4mKR\u0019Qi!\u0001\t\u0011\r\r!1 a\u0001\u0005S\fAA]3di\"91q\u0001\u0001\u0005\u0002\r%\u0011a\u0005:f[>4X\r\u0012:boJ+7\r^1oO2,GcA#\u0004\f!9!q\\B\u0003\u0001\u0004I\u0004bBB\b\u0001\u0011\u00051\u0011C\u0001\u0007e\u0016tG-\u001a:\u0015\u000f\u0015\u001c\u0019b!\u0006\u0004&!A!QTB\u0007\u0001\u0004\u0011y\n\u0003\u0005\u0004\u0018\r5\u0001\u0019AB\r\u00035\u0019\b.\u00199f%\u0016tG-\u001a:feB!11DB\u0011\u001b\t\u0019iBC\u0002\u0004 e\fqa\u001a7vi&d7/\u0003\u0003\u0004$\ru!!D*iCB,'+\u001a8eKJ,'\u000f\u0003\u0005\u0003(\u000e5\u0001\u0019\u0001BU\u0011\u001d\u0019I\u0003\u0001C\u0001\u0003w\fq\u0001Z5ta>\u001cX\rC\u0005\u0004.\u0001\t\n\u0011\"\u0001\u00040\u0005Y2\u000f[8x!&\u001cG/\u001e:f\u0005ft\u0015-\\3%I\u00164\u0017-\u001e7uIQ*\"a!\r+\u0007}\u001b\u0019d\u000b\u0002\u00046A!1qGB!\u001b\t\u0019ID\u0003\u0003\u0004<\ru\u0012!C;oG\",7m[3e\u0015\r\u0019yDC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\"\u0007s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00199\u0005AI\u0001\n\u0003\u0019y#A\rtQ><\b+[2ukJ,Gj\\8qI\u0011,g-Y;mi\u0012\"\u0004\"CB&\u0001E\u0005I\u0011AB'\u0003e\u0019\bn\\<QS\u000e$XO]3M_>\u0004H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r=#fA\u001d\u00044\u0001")
public class WindowManager
implements ThreadChecked,
LazyLogging {
    private final RpgAssetManager assets;
    private final Project project;
    private final int screenW;
    private final int screenH;
    private final boolean renderingOffForTesting;
    private final AnimationManager animationManager;
    private float transitionAlpha;
    private final FloatTweener transitionTweener;
    private final Color tintColor;
    private final Object tintTweener;
    private Windowskin windowskin;
    private Texture windowskinTexture;
    private final Msgfont font;
    private BitmapFont _fontbmp;
    private final Option<PictureLike>[] pictures;
    private final ArrayBuffer<Window> windows;
    private MutableList<ScreenText> screenTextArray;
    private MutableList<Rectangle> rectangleArray;
    private final Logger logger;
    private Thread rpgboss$lib$ThreadChecked$$_boundThread;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        WindowManager windowManager = this;
        synchronized (windowManager) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Thread rpgboss$lib$ThreadChecked$$_boundThread() {
        return this.rpgboss$lib$ThreadChecked$$_boundThread;
    }

    @Override
    public void rpgboss$lib$ThreadChecked$$_boundThread_$eq(Thread x$1) {
        this.rpgboss$lib$ThreadChecked$$_boundThread = x$1;
    }

    @Override
    public void rebindToCurrentThread() {
        ThreadChecked$class.rebindToCurrentThread(this);
    }

    @Override
    public void assertOnBoundThread() {
        ThreadChecked$class.assertOnBoundThread(this);
    }

    @Override
    public void assertOnDifferentThread() {
        ThreadChecked$class.assertOnDifferentThread(this);
    }

    @Override
    public boolean onBoundThread() {
        return ThreadChecked$class.onBoundThread(this);
    }

    public RpgAssetManager assets() {
        return this.assets;
    }

    public Project project() {
        return this.project;
    }

    public int screenW() {
        return this.screenW;
    }

    public int screenH() {
        return this.screenH;
    }

    public boolean renderingOffForTesting() {
        return this.renderingOffForTesting;
    }

    public AnimationManager animationManager() {
        return this.animationManager;
    }

    public float transitionAlpha() {
        return this.transitionAlpha;
    }

    public void transitionAlpha_$eq(float x$1) {
        this.transitionAlpha = x$1;
    }

    public FloatTweener transitionTweener() {
        return this.transitionTweener;
    }

    public Color tintColor() {
        return this.tintColor;
    }

    public Object tintTweener() {
        return this.tintTweener;
    }

    public Windowskin windowskin() {
        return this.windowskin;
    }

    public void windowskin_$eq(Windowskin x$1) {
        this.windowskin = x$1;
    }

    public Texture windowskinTexture() {
        return this.windowskinTexture;
    }

    public void windowskinTexture_$eq(Texture x$1) {
        this.windowskinTexture = x$1;
    }

    public Msgfont font() {
        return this.font;
    }

    public BitmapFont fontbmp() {
        if (this._fontbmp() == null) {
            this.updateBitmapFont("");
        }
        return this._fontbmp();
    }

    public BitmapFont _fontbmp() {
        return this._fontbmp;
    }

    public void _fontbmp_$eq(BitmapFont x$1) {
        this._fontbmp = x$1;
    }

    public void updateBitmapFont(String distinctChars2) {
        this._fontbmp_$eq(this.renderingOffForTesting() ? null : this.font().getBitmapFont(distinctChars2));
    }

    public Option<PictureLike>[] pictures() {
        return this.pictures;
    }

    private ArrayBuffer<Window> windows() {
        return this.windows;
    }

    public void setTransition(float endAlpha, float duration) {
        this.assertOnBoundThread();
        this.transitionTweener().tweenTo(BoxesRunTime.boxToFloat(endAlpha), duration);
    }

    public void runAfterTransition(Function0<BoxedUnit> closure) {
        this.transitionTweener().runAfterDone(closure);
    }

    public void finishTransition() {
        this.assertOnBoundThread();
        this.transitionTweener().finish();
    }

    public boolean inTransition() {
        return !this.transitionTweener().done();
    }

    public void setWindowskin(String windowskinPath) {
        if (this.windowskinTexture() != null) {
            this.windowskinTexture().dispose();
        }
        this.windowskin_$eq((Windowskin)Windowskin$.MODULE$.readFromDisk(this.project(), windowskinPath, ManifestFactory$.MODULE$.classType(WindowskinMetadata.class)));
        if (!this.renderingOffForTesting()) {
            this.windowskinTexture_$eq(new Texture(this.windowskin().getGdxFileHandle()));
        }
    }

    public void addWindow(Window window) {
        this.assertOnBoundThread();
        this.windows().prepend(Predef$.MODULE$.wrapRefArray((Object[])new Window[]{window}));
    }

    public ArrayBuffer<Window> removeWindow(Window window) {
        this.assertOnBoundThread();
        return (ArrayBuffer)this.windows().$minus$eq((Object)window);
    }

    public void focusWindow(Window window) {
        this.assertOnBoundThread();
        this.removeWindow(window);
        this.addWindow(window);
    }

    public void showPictureByName(int slot, String name, Layout layout, float alpha) {
        this.assertOnBoundThread();
        Picture picture = (Picture)Picture$.MODULE$.readFromDisk(this.project(), name, ManifestFactory$.MODULE$.classType(PictureMetadata.class));
        this.showPicture(slot, new TexturePicture<PictureMetadata>(this, this.assets(), picture, layout, alpha));
    }

    public void showPictureLoop(int slot, String folderPath, Layout layout, float alpha, int framesPerSecond) {
        this.assertOnBoundThread();
        String[] filesUnderPath = Picture$.MODULE$.listResourcesUnderPath(this.project(), folderPath);
        if (!Predef$.MODULE$.refArrayOps((Object[])filesUnderPath).isEmpty()) {
            TexturePicture[] pictureArray = (TexturePicture[])Predef$.MODULE$.refArrayOps((Object[])filesUnderPath).map(new Serializable(this, layout, alpha){
                private final /* synthetic */ WindowManager $outer;
                private final Layout layout$1;
                private final float alpha$1;

                public final TexturePicture<PictureMetadata> apply(String picturePath) {
                    Picture picture = (Picture)Picture$.MODULE$.readFromDisk(this.$outer.project(), picturePath, ManifestFactory$.MODULE$.classType(PictureMetadata.class));
                    return new TexturePicture<PictureMetadata>(this.$outer, this.$outer.assets(), picture, this.layout$1, this.alpha$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.layout$1 = layout$1;
                    this.alpha$1 = alpha$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TexturePicture.class)));
            this.showPicture(slot, new PictureSequence((PictureLike[])pictureArray, true, framesPerSecond));
        }
    }

    public void showPicture(int slot, PictureLike newPicture) {
        this.assertOnBoundThread();
        if (slot < 0 || slot >= PictureSlots$.MODULE$.NUM_SLOTS()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Picture slots must be in range [0, 64).");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        this.pictures()[slot].map(new Serializable(this){

            public final void apply(PictureLike x$2) {
                x$2.dispose();
            }
        });
        this.pictures()[slot] = new Some<PictureLike>(newPicture);
    }

    public float showPictureByName$default$4() {
        return 1.0f;
    }

    public float showPictureLoop$default$4() {
        return 1.0f;
    }

    public int showPictureLoop$default$5() {
        return 30;
    }

    public void movePicture(int slot, float duration, Layout newLayout, float newAlpha) {
        if (this.pictures()[slot].isDefined()) {
            TexturePicture<?> texturePicture;
            PictureLike pictureLike = this.pictures()[slot].get();
            if (pictureLike instanceof TexturePicture) {
                TexturePicture<?> texturePicture2;
                texturePicture = texturePicture2 = (TexturePicture<?>)pictureLike;
            } else if (pictureLike instanceof MovedPicture) {
                MovedPicture movedPicture = (MovedPicture)pictureLike;
                texturePicture = movedPicture.inner();
            } else {
                texturePicture = null;
            }
            TexturePicture<?> originalPicture = texturePicture;
            if (originalPicture != null) {
                this.pictures()[slot] = new Some<MovedPicture>(new MovedPicture(this, originalPicture, duration, newLayout, newAlpha));
            }
        }
    }

    public void hidePicture(int slot) {
        this.assertOnBoundThread();
        if (slot < 0 || slot >= PictureSlots$.MODULE$.NUM_SLOTS()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Picture slots must be in range [0, 64).");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        this.pictures()[slot].map(new Serializable(this){

            public final void apply(PictureLike x$3) {
                x$3.dispose();
            }
        });
        this.pictures()[slot] = None$.MODULE$;
    }

    public void reset() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.pictures().length).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
            private final /* synthetic */ WindowManager $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.hidePicture(i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.tintColor().set(0.0f, 0.0f, 0.0f, 0.0f);
        this.windows().foreach(new Serializable(this){

            public final void apply(Window x$4) {
                x$4.startClosing();
            }
        });
        this.windows().clear();
    }

    public HashSet<AnimationPlayer> update(float delta) {
        this.transitionTweener().update(delta);
        this.tintTweener().update(delta);
        this.windows().foreach(new Serializable(this, delta){
            private final float delta$1;

            public final Object apply(Window x$5) {
                return x$5.update(this.delta$1);
            }
            {
                this.delta$1 = delta$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])this.pictures()).foreach(new Serializable(this, delta){
            public final float delta$1;

            public final Option<BoxedUnit> apply(Option<PictureLike> x$6) {
                return x$6.map(new Serializable(this){
                    private final /* synthetic */ $anonfun$update$2 $outer;

                    public final void apply(PictureLike x$7) {
                        x$7.update(this.$outer.delta$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.delta$1 = delta$1;
            }
        });
        ArrayBuffer toRemove = (ArrayBuffer)this.windows().filter((Function1)((Object)new Serializable(this){

            public final boolean apply(Window x$8) {
                return x$8.state() == Window$.MODULE$.Closed();
            }
        }));
        toRemove.foreach(new Serializable(this){

            public final Object apply(Window x$9) {
                return x$9.removeFromWindowManagerAndInputs();
            }
        });
        return this.animationManager().update(delta);
    }

    public void preMapRender(SpriteBatch batch, OrthographicCamera screenCamera) {
        batch.begin();
        batch.setProjectionMatrix(screenCamera.combined);
        batch.enableBlending();
        batch.setBlendFunction(770, 771);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(PictureSlots$.MODULE$.BELOW_MAP()), PictureSlots$.MODULE$.ABOVE_MAP()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, batch){
            private final /* synthetic */ WindowManager $outer;
            public final SpriteBatch batch$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.pictures()[i].foreach(new Serializable(this){
                    private final /* synthetic */ $anonfun$preMapRender$1 $outer;

                    public final void apply(PictureLike pic) {
                        pic.render(this.$outer.rpgboss$player$WindowManager$$anonfun$$$outer(), this.$outer.batch$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ WindowManager rpgboss$player$WindowManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batch$1 = batch$1;
            }
        }));
        batch.end();
    }

    public MutableList<ScreenText> screenTextArray() {
        return this.screenTextArray;
    }

    public void screenTextArray_$eq(MutableList<ScreenText> x$1) {
        this.screenTextArray = x$1;
    }

    public boolean addDrawText(ScreenText text2) {
        this.screenTextArray().foreach(new Serializable(this, text2){
            private final /* synthetic */ WindowManager $outer;
            private final ScreenText text$1;

            public final Object apply(ScreenText text2) {
                return text2.id() == this.text$1.id() ? BoxesRunTime.boxToBoolean(this.$outer.removeDrawText(this.text$1.id())) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.text$1 = text$1;
            }
        });
        this.screenTextArray().$plus$eq((Object)text2);
        return true;
    }

    public boolean removeDrawText(int id) {
        BooleanRef removedSomething = BooleanRef.create(false);
        ObjectRef<MutableList> newTextArray = ObjectRef.create((MutableList)MutableList$.MODULE$.apply(Nil$.MODULE$));
        this.screenTextArray().foreach(new Serializable(this, id, removedSomething, newTextArray){
            private final int id$1;
            private final BooleanRef removedSomething$1;
            private final ObjectRef newTextArray$1;

            public final Object apply(ScreenText text2) {
                Object object;
                if (text2.id() != this.id$1) {
                    object = ((MutableList)this.newTextArray$1.elem).$plus$eq(text2);
                } else {
                    this.removedSomething$1.elem = true;
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.id$1 = id$1;
                this.removedSomething$1 = removedSomething$1;
                this.newTextArray$1 = newTextArray$1;
            }
        });
        this.screenTextArray_$eq((MutableList)newTextArray.elem);
        return removedSomething.elem;
    }

    public MutableList<Rectangle> rectangleArray() {
        return this.rectangleArray;
    }

    public void rectangleArray_$eq(MutableList<Rectangle> x$1) {
        this.rectangleArray = x$1;
    }

    public boolean addDrawRectangle(Rectangle rect) {
        this.rectangleArray().foreach(new Serializable(this, rect){
            private final /* synthetic */ WindowManager $outer;
            private final Rectangle rect$1;

            public final Object apply(Rectangle text2) {
                return text2.id() == this.rect$1.id() ? BoxesRunTime.boxToBoolean(this.$outer.removeDrawText(this.rect$1.id())) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rect$1 = rect$1;
            }
        });
        this.rectangleArray().$plus$eq((Object)rect);
        return true;
    }

    public boolean removeDrawRectangle(int id) {
        BooleanRef removedSomething = BooleanRef.create(false);
        ObjectRef<MutableList> newTextArray = ObjectRef.create((MutableList)MutableList$.MODULE$.apply(Nil$.MODULE$));
        this.rectangleArray().foreach(new Serializable(this, id, removedSomething, newTextArray){
            private final int id$2;
            private final BooleanRef removedSomething$2;
            private final ObjectRef newTextArray$2;

            public final Object apply(Rectangle rect) {
                Object object;
                if (rect.id() != this.id$2) {
                    object = ((MutableList)this.newTextArray$2.elem).$plus$eq(rect);
                } else {
                    this.removedSomething$2.elem = true;
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.id$2 = id$2;
                this.removedSomething$2 = removedSomething$2;
                this.newTextArray$2 = newTextArray$2;
            }
        });
        this.rectangleArray_$eq((MutableList)newTextArray.elem);
        return removedSomething.elem;
    }

    public void render(SpriteBatch batch, ShapeRenderer shapeRenderer, OrthographicCamera screenCamera) {
        batch.setProjectionMatrix(screenCamera.combined);
        batch.enableBlending();
        batch.setBlendFunction(770, 771);
        shapeRenderer.setProjectionMatrix(screenCamera.combined);
        if (this.tintColor().a != 0.0f) {
            Gdx.gl.glEnable(3042);
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            shapeRenderer.setColor(this.tintColor());
            shapeRenderer.rect(0.0f, 0.0f, this.screenW(), this.screenH());
            shapeRenderer.end();
        }
        batch.begin();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(PictureSlots$.MODULE$.ABOVE_MAP()), PictureSlots$.MODULE$.ABOVE_WINDOW()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, batch){
            private final /* synthetic */ WindowManager $outer;
            public final SpriteBatch batch$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.pictures()[i].foreach(new Serializable(this){
                    private final /* synthetic */ $anonfun$render$1 $outer;

                    public final void apply(PictureLike pic) {
                        pic.render(this.$outer.rpgboss$player$WindowManager$$anonfun$$$outer(), this.$outer.batch$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ WindowManager rpgboss$player$WindowManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batch$2 = batch$2;
            }
        }));
        batch.end();
        this.animationManager().render(batch, shapeRenderer, screenCamera);
        batch.begin();
        this.windows().reverseIterator().foreach(new Serializable(this, batch){
            private final SpriteBatch batch$2;

            public final void apply(Window x$10) {
                x$10.render(this.batch$2);
            }
            {
                this.batch$2 = batch$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(PictureSlots$.MODULE$.ABOVE_WINDOW()), PictureSlots$.MODULE$.NUM_SLOTS()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, batch){
            private final /* synthetic */ WindowManager $outer;
            public final SpriteBatch batch$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.pictures()[i].foreach(new Serializable(this){
                    private final /* synthetic */ $anonfun$render$2 $outer;

                    public final void apply(PictureLike pic) {
                        pic.render(this.$outer.rpgboss$player$WindowManager$$anonfun$$$outer(), this.$outer.batch$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ WindowManager rpgboss$player$WindowManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batch$2 = batch$2;
            }
        }));
        batch.end();
        batch.begin();
        this.rectangleArray().foreach(new Serializable(this, batch, shapeRenderer){
            private final /* synthetic */ WindowManager $outer;
            private final SpriteBatch batch$2;
            private final ShapeRenderer shapeRenderer$1;

            public final void apply(Rectangle rect) {
                rect.render(this.$outer, this.batch$2, this.shapeRenderer$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batch$2 = batch$2;
                this.shapeRenderer$1 = shapeRenderer$1;
            }
        });
        batch.end();
        batch.begin();
        this.screenTextArray().foreach(new Serializable(this, batch){
            private final /* synthetic */ WindowManager $outer;
            private final SpriteBatch batch$2;

            public final void apply(ScreenText text2) {
                text2.render(this.$outer, this.batch$2, this.$outer.font());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batch$2 = batch$2;
            }
        });
        batch.end();
        if (this.transitionAlpha() != 0.0f) {
            Gdx.gl.glEnable(3042);
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            shapeRenderer.setColor(0.0f, 0.0f, 0.0f, this.transitionAlpha());
            shapeRenderer.rect(0.0f, 0.0f, this.screenW(), this.screenH());
            shapeRenderer.end();
        }
    }

    public void dispose() {
        this.assertOnBoundThread();
        Predef$.MODULE$.refArrayOps((Object[])this.pictures()).foreach(new Serializable(this){

            public final void apply(Option<PictureLike> pictureOpt) {
                pictureOpt.foreach(new Serializable(this){

                    public final void apply(PictureLike picture) {
                        picture.dispose();
                    }
                });
            }
        });
        if (this.windowskinTexture() != null) {
            this.windowskinTexture().dispose();
        }
        this.animationManager().dispose();
    }

    public WindowManager(RpgAssetManager assets, Project project, int screenW, int screenH, boolean renderingOffForTesting) {
        this.assets = assets;
        this.project = project;
        this.screenW = screenW;
        this.screenH = screenH;
        this.renderingOffForTesting = renderingOffForTesting;
        ThreadChecked$class.$init$(this);
        LazyLogging$class.$init$(this);
        this.animationManager = new AnimationManager(screenW, screenH);
        this.transitionAlpha = 1.0f;
        this.transitionTweener = new FloatTweener((Function0<Object>)((Object)new Serializable(this){
            private final /* synthetic */ WindowManager $outer;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return this.$outer.transitionAlpha();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Function1<Object, BoxedUnit>)((Object)new Serializable(this){
            private final /* synthetic */ WindowManager $outer;

            public final void apply(float x$1) {
                this.apply$mcVF$sp(x$1);
            }

            public void apply$mcVF$sp(float x$1) {
                this.$outer.transitionAlpha_$eq(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.tintColor = new Color();
        this.tintTweener = new Tweener<Color>(this){
            private Color _startValue;
            private Color _endValue;
            private final /* synthetic */ WindowManager $outer;
            private float rpgboss$player$Tweener$$_age;
            private boolean rpgboss$player$Tweener$$_done;
            private float rpgboss$player$Tweener$$_tweenDuration;
            private final ArrayBuffer<Function0<BoxedUnit>> rpgboss$player$Tweener$$_doneCallbacks;

            public float rpgboss$player$Tweener$$_age() {
                return this.rpgboss$player$Tweener$$_age;
            }

            public void rpgboss$player$Tweener$$_age_$eq(float x$1) {
                this.rpgboss$player$Tweener$$_age = x$1;
            }

            public boolean rpgboss$player$Tweener$$_done() {
                return this.rpgboss$player$Tweener$$_done;
            }

            public void rpgboss$player$Tweener$$_done_$eq(boolean x$1) {
                this.rpgboss$player$Tweener$$_done = x$1;
            }

            public float rpgboss$player$Tweener$$_tweenDuration() {
                return this.rpgboss$player$Tweener$$_tweenDuration;
            }

            public void rpgboss$player$Tweener$$_tweenDuration_$eq(float x$1) {
                this.rpgboss$player$Tweener$$_tweenDuration = x$1;
            }

            public ArrayBuffer<Function0<BoxedUnit>> rpgboss$player$Tweener$$_doneCallbacks() {
                return this.rpgboss$player$Tweener$$_doneCallbacks;
            }

            public void rpgboss$player$Tweener$_setter_$rpgboss$player$Tweener$$_doneCallbacks_$eq(ArrayBuffer x$1) {
                this.rpgboss$player$Tweener$$_doneCallbacks = x$1;
            }

            public boolean done() {
                return Tweener$class.done(this);
            }

            public void tweenTo(Object endValue, float duration) {
                Tweener$class.tweenTo(this, endValue, duration);
            }

            public void flushCallbacks() {
                Tweener$class.flushCallbacks(this);
            }

            public void runAfterDone(Function0<BoxedUnit> closure) {
                Tweener$class.runAfterDone(this, closure);
            }

            public void update(float delta) {
                Tweener$class.update(this, delta);
            }

            public void finish() {
                Tweener$class.finish(this);
            }

            public Color _startValue() {
                return this._startValue;
            }

            public void _startValue_$eq(Color x$1) {
                this._startValue = x$1;
            }

            public Color _endValue() {
                return this._endValue;
            }

            public void _endValue_$eq(Color x$1) {
                this._endValue = x$1;
            }

            public Color get() {
                return this.$outer.tintColor();
            }

            public void set(Color newValue) {
                this.$outer.tintColor().set(newValue);
            }

            public Color interpolate(Color startValue, Color endValue, float alpha) {
                Color newColor = new Color(startValue);
                newColor.lerp(endValue, alpha);
                return newColor;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Tweener$class.$init$(this);
                this._startValue = new Color();
                this._endValue = new Color();
            }
        };
        this.windowskin = null;
        this.windowskinTexture = null;
        this.font = (Msgfont)Msgfont$.MODULE$.readFromDisk(project, project.data().startup().msgfont(), ManifestFactory$.MODULE$.classType(MsgfontMetadata.class));
        this._fontbmp = null;
        this.pictures = (Option[])Array$.MODULE$.fill(PictureSlots$.MODULE$.NUM_SLOTS(), new Serializable(this){

            public final None$ apply() {
                return None$.MODULE$;
            }
        }, ClassTag$.MODULE$.apply(Option.class));
        this.windows = new ArrayBuffer();
        this.setWindowskin(project.data().startup().windowskin());
        this.screenTextArray = (MutableList)MutableList$.MODULE$.apply(Nil$.MODULE$);
        this.rectangleArray = (MutableList)MutableList$.MODULE$.apply(Nil$.MODULE$);
    }
}

